<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
    exit;
}

include 'db_connection.php';

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->email) || !isset($data->password) || empty($data->email) || empty($data->password)) {
    echo json_encode(["success" => false, "message" => "Email and password are required"]);
    exit;
}

$email = $data->email;
$password = $data->password;

// Use prepared statement for security
$stmt = $conn->prepare("SELECT id, u_password, u_balance FROM data_user WHERE u_email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();
    if (password_verify($password, $user['u_password'])) {
        echo json_encode([
            "success" => true,
            "message" => "Login successful",
            "balance" => $user['u_balance'],
            "id" => $user['id']
        ]);
    } else {
        echo json_encode(["success" => false, "message" => "Wrong password"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Email not found"]);
}

$conn->close();
?>
