<?php
// Prevent unwanted output
ob_start();
header('Content-Type: application/json');
ini_set('display_errors', 0);
error_reporting(0);

// Include dependencies
require_once 'db_connection.php';
require_once 'server-times.php';
require_once 'add-balance.php';

// Read JSON input
$payload = json_decode(file_get_contents("php://input"), true);

// Validate payload
if (!isset($payload['productId'], $payload['purchaseId']) || empty($payload['productId']) || empty($payload['purchaseId'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields: productId or purchaseId.']);
    exit;
}

// Extract and sanitize inputs
$userId     = isset($payload['userId']) ? $conn->real_escape_string($payload['userId']) : 0;
$productId  = $conn->real_escape_string($payload['productId']);
$purchaseId = $conn->real_escape_string($payload['purchaseId']);
$appId      = !empty($payload['app_id']) ? $conn->real_escape_string($payload['app_id']) : null;

$quantity = isset($payload['quantity']) ? (int)$payload['quantity'] : 1;


// Fetch product info
$productSql = "SELECT sale_price, product_name FROM inapp_product WHERE product_id = '$productId'";
$productRes = $conn->query($productSql);

if (!$productRes || $productRes->num_rows < 1) {
    echo json_encode(['status' => 'error', 'message' => 'Product not found.']);
    exit;
}

$productData = $productRes->fetch_assoc();
$price = $productData['sale_price'];
$totalPrice = $price * $quantity;
$pName = $productData['product_name'];

// Check for duplicate purchaseId
$checkSql = "SELECT id FROM purchase_history WHERE purchase_id = '$purchaseId'";
$exists = $conn->query($checkSql);

if ($exists->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Purchase ID already exists.']);
    exit;
}

// Insert purchase
$currentDate = getCurrentTime();
$insertSql = "INSERT INTO purchase_history 
    (user_id, product_name, product_id, purchase_id, sale_price, date, app_id, quantity, price)
    VALUES ('$userId', '$pName', '$productId', '$purchaseId', '$totalPrice', '$currentDate', '$appId', '$quantity', '$price')";

if ($conn->query($insertSql)) {
    // Update balance
    $updateResult = updateUserBalance($conn, $userId, $totalPrice);

    // Ensure response is JSON
    if (is_array($updateResult)) {
        echo json_encode($updateResult);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Unexpected error updating balance.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to save purchase data.']);
}

$conn->close();
ob_end_flush(); // Flush output buffer
?>
