<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
    exit;
}

include 'db_connection.php';
require_once 'server-times.php';

$currentDate = getCurrentTime();

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->email) || !isset($data->password) || empty($data->email) || empty($data->password)) {
    echo json_encode(["success" => false, "message" => "Email and password are required"]);
    exit;
}

$email = $data->email;
$password = password_hash($data->password, PASSWORD_DEFAULT);

// Check if email already exists
$stmt = $conn->prepare("SELECT id FROM data_user WHERE u_email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    echo json_encode(["success" => false, "message" => "Email already exists"]);
    exit;
}

// Insert new user
$insert = $conn->prepare("INSERT INTO data_user (u_email, u_password, u_balance, JoinDate) VALUES (?, ?, 0, ?)");
$insert->bind_param("sss", $email, $password, $currentDate);

if ($insert->execute()) {
    // Insert সফল, এখন আবার ইউজারটি খুঁজে আনা
    $select = $conn->prepare("SELECT id, u_balance FROM data_user WHERE u_email = ? LIMIT 1");
    $select->bind_param("s", $email);
    $select->execute();
    $result = $select->get_result();

    if ($result && $result->num_rows > 0) {
        $user = $result->fetch_assoc();
        echo json_encode([
            "success" => true,
            "message" => "Registered successfully",
            "balance" => $user['u_balance'],
            "id" => $user['id']
        ]);
    } else {
        echo json_encode(["success" => false, "message" => "User created, but info fetch failed"]);
    }

} else {
    echo json_encode(["success" => false, "message" => "Registration failed"]);
}

$conn->close();
?>
