<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json");

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
    exit;
}

// Connection include
include 'db_connection.php';
require_once 'server-times.php';

$currentDate = getCurrentTime();

// Parse input
$data = json_decode(file_get_contents("php://input"));

// Check if email and password exist in the request
if (!isset($data->email) || !isset($data->password) || empty($data->email) || empty($data->password)) {
    echo json_encode(["success" => false, "message" => "Email and password are required"]);
    exit;
}

$email = $conn->real_escape_string($data->email);
$password = $data->password;

// Check if user exists
$query = "SELECT * FROM data_user WHERE u_email = '$email'";
$result = $conn->query($query);

if ($result->num_rows > 0) {
    // User exists, verify password
    $user = $result->fetch_assoc();
    if (password_verify($password, $user['u_password'])) {
        echo json_encode([
            "success" => true,
            "message" => "Login successful",
            "balance" => $user['u_balance'],
            "id" => $user['id'],
        ]);
    } else {
        echo json_encode(["success" => false, "message" => "Wrong password"]);
    }
} else {
    // Register new user
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    $insert = "INSERT INTO data_user (u_email, u_password, u_balance, JoinDate) VALUES ('$email', '$hashedPassword', 0, '$currentDate')";

    if ($conn->query($insert)) {
        // Insert সফল হলে, ইউজার টেবিল থেকে আবার আইডি ও ব্যালেন্স আনো
        $userQuery = "SELECT id, u_balance FROM data_user WHERE u_email = '$email' LIMIT 1";
        $userResult = $conn->query($userQuery);

        if ($userResult && $userResult->num_rows > 0) {
            $user = $userResult->fetch_assoc();
            echo json_encode([
                "success" => true,
                "message" => "Registered successfully",
                "balance" => $user['u_balance'],
                "id" => $user['id']
            ]);
        } else {
            echo json_encode(["success" => false, "message" => "User created, but info fetch failed"]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Registration failed"]);
    }

}

$conn->close();
?>
